package gov.va.med.mhv.bluebutton.web.bean;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.event.ActionEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean(name = "ccdAttributes", eager = true)
@Component
@Scope("session")
public class CcdAttributes implements Serializable {
	
private static final long serialVersionUID = -4870606207281941015L;
	
	private static Logger logger = LogManager.getLogger(CcdAttributes.class);

	private String dateGenerated = "";
	private String ccdType = "";	
	
	
	public String getDateGenerated() {
		return dateGenerated;
	}
	public void setDateGenerated(String dateGenerated) {
		this.dateGenerated = dateGenerated;
	}
	public String getCcdType() {
		return ccdType;
	}
	public void setCcdType(String ccdType) {
		this.ccdType = ccdType;
	}

	public void attributeListener(ActionEvent event){
		dateGenerated = (String)event.getComponent().getAttributes().get("dateGenerated");	
		ccdType = (String)event.getComponent().getAttributes().get("ccdType");
    }
	
	
}

